
clear; clc; 

COUNTRIES = ['CAN'; 'FRA'; 'DEU'; 'ITA'; 'JPN'; 'GBR'];

WhereAreWe = cd; 
path(path,[WhereAreWe '\Data']);
path(path,[WhereAreWe '\Subcodes']);

[Raw_QoQ_Data,RelatedInfoQoQ] = xlsread('OECD Data.xlsx','QoQ');
RelatedInfoQoQ = RelatedInfoQoQ(2:end,:);
[Raw_YoY_Data,RelatedInfoYoY] = xlsread('OECD Data.xlsx','YoY');
RelatedInfoYoY = RelatedInfoYoY(2:end,:);

SPLITTING_SAMPLE = '1984-Q2';

Quantili = [.05,.16,.84,.95]; 
PickQuantiliTable = [2,3];


%% Construct QoQ Database
for jj = 1:size(COUNTRIES,1)
    FindCountry = strmatch(COUNTRIES(jj,:), RelatedInfoQoQ(:,1), 'exact');
    QoQ_DATA(:,jj) = Raw_QoQ_Data(FindCountry,1);
%     DATALevel(:,jj) = cumsum([0; QoQ_DATA(:,jj)]/100);
    DATALevel(:,jj) = log(cumprod([1; (1+QoQ_DATA(:,jj)/100)]));
    DATADetrended(:,jj)=DATALevel(:,jj) - RotembergDetrend(DATALevel(:,jj));
    close all 
    
    GDPdet_QoQ(:,jj) = DATADetrended(2:end,jj)-DATADetrended(2-1:end-1,jj); 
    GDPdet_YoY(:,jj) = DATADetrended(5:end,jj)-DATADetrended(5-4:end-4,jj); 
    
    if jj==1
    SplittingDateQoQ = strmatch(SPLITTING_SAMPLE, RelatedInfoQoQ(FindCountry,6), 'exact');
    SplittingDateYoY = SplittingDateQoQ-3;
    end
end

%% CALCULATE Skewness

for jj=1:size(COUNTRIES,1)
    
    XX = GDPdet_QoQ(1:SplittingDateQoQ,jj);
    if jj==2; XX([33,34])=NaN; XX=XX(isfinite(XX)); end 
    [Skew,SD_Skew,SkewQuant]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_QoQ(2*(jj-1)+1,1:2) = [[Skew NaN]];
    TABLE_SKEWNESS_QoQ(2*(jj-1)+2,1:2) = [SkewQuant(PickQuantiliTable)];
    
    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMI_QoQ(2*(jj-1)+1,1:2) = [RatioSV NaN];
    TABLE_SEMI_QoQ(2*(jj-1)+2,1:2) = [RatioSVQuant(PickQuantiliTable)];
    
    %%
    XX = GDPdet_QoQ(SplittingDateQoQ+1:end,jj);
    [Skew,SD_Skew,SkewQuant]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_QoQ(2*(jj-1)+1,3:4) = [[Skew NaN]];
    TABLE_SKEWNESS_QoQ(2*(jj-1)+2,3:4) = [SkewQuant(PickQuantiliTable)];
    
    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMI_QoQ(2*(jj-1)+1,3:4) = [RatioSV NaN];
    TABLE_SEMI_QoQ(2*(jj-1)+2,3:4) = [RatioSVQuant(PickQuantiliTable)];
    
    %%
    XX = GDPdet_YoY(1:SplittingDateQoQ,jj);
    if jj==2; XX([30,34])=NaN; XX=XX(isfinite(XX)); end 
    [Skew,SD_Skew,SkewQuant]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_YoY(2*(jj-1)+1,1:2) = [[Skew NaN]];
    TABLE_SKEWNESS_YoY(2*(jj-1)+2,1:2) = [SkewQuant(PickQuantiliTable)];
    
    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMI_YoY(2*(jj-1)+1,1:2) = [RatioSV NaN];
    TABLE_SEMI_YoY(2*(jj-1)+2,1:2) = [RatioSVQuant(PickQuantiliTable)];
    
    %%
    XX = GDPdet_YoY(SplittingDateQoQ+1:end,jj);
    [Skew,SD_Skew,SkewQuant]=SkewBootstrap(XX,Quantili); 
    TABLE_SKEWNESS_YoY(2*(jj-1)+1,3:4) = [[Skew NaN]];
    TABLE_SKEWNESS_YoY(2*(jj-1)+2,3:4) = [SkewQuant(PickQuantiliTable)];
    
    [PosSemiVar,NegSemiVar,RatioSV,SD_RatioSV,RatioSVQuant]=SemiVarRatioBootstrap(XX,Quantili); 
    TABLE_SEMI_YoY(2*(jj-1)+1,3:4) = [RatioSV NaN];
    TABLE_SEMI_YoY(2*(jj-1)+2,3:4) = [RatioSVQuant(PickQuantiliTable)];
    
    
end
    
TABLE_QUARTERLY = [TABLE_SKEWNESS_QoQ TABLE_SEMI_QoQ];
TABLE_ANNUAL = [TABLE_SKEWNESS_YoY TABLE_SEMI_YoY];

BIG_TABLE = [TABLE_QUARTERLY NaN*TABLE_QUARTERLY(:,1) TABLE_ANNUAL]; 
ShowTABLE_4 = round(BIG_TABLE,3);

% swp2(BIG_TABLE,'Table_G7.tex');



